Type MenuEntry
	Field _id:Int
	Field _displayName:String
	Field _x:Float
	Field _y:Float
	Field _highlighted:Int
	Field _clicked:Int
	
	Function Create:MenuEntry(id:Int, name:String, x:Float, y:Float) 
		Local me:MenuEntry = New MenuEntry
		me._id = id
		me._displayName = name
		me._x = x
		me._y = y
		Return me
	End Function
	
	Method GetId:Int() 
		Return _id
	End Method
	
	Method GetDisplayName:String() 
		Return _displayName
	End Method
	
	
	Method WasClicked:Int() 
		Local clicked:Int = _clicked
		_clicked = False
		Return clicked
	End Method
	
	Method Draw() 
		Local r:Int, g:Int, b:Int
		GetColor(r, g, b) 
		If _highlighted Then
			SetColor(200, 140, 140)
			DrawText(GetDisplayName(), _x + 1, _y + 1)
			SetColor(255, 0, 0)
		End If
		DrawText(GetDisplayName(), _x, _y) 
		
		SetColor(r, g, b) 
	End Method
	
	Method Update(mHit:Int) 
		Local msx:Float = MouseX() 
		Local msy:Float = MouseY() 
		
		_highlighted = False
		Local gutter:Float = 6
		If msx > _x - gutter And msx < _x + TextWidth(GetDisplayName()) + gutter Then
			If msy > _y - gutter And msy < _y + TextHeight(getdisplayname()) + gutter Then
				_highlighted = True
			End If
		End If
		
		If _highlighted And mHit Then
			_clicked = True
		End If
	End Method
End Type